// HttpSvrDoc.cpp : implementation of the CHttpSvrDoc class
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1996 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.
//
// Note that your filters probably won't have an #ifdef like this one.
// The project file for this sample allows you to build the sample as
// a statically linked regular MFC DLL (that is, with _AFXDLL defined)
// or as a DLL that doesn't use MFC classes aside from the ISAPI 
// support classes (that is, without _AFXDLL defined).

#include "stdafx.h"

#include "Listen.h"
#include "HttpSvr.h"
#include "HttpDoc.h"
#include "Request.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CHttpSvrDoc

IMPLEMENT_DYNCREATE(CHttpSvrDoc, CDocument)

BEGIN_MESSAGE_MAP(CHttpSvrDoc, CDocument)
	//{{AFX_MSG_MAP(CHttpSvrDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CHttpSvrDoc construction/destruction

CHttpSvrDoc::CHttpSvrDoc()
{
}

CHttpSvrDoc::~CHttpSvrDoc()
{
	// get rid of any lingering requests, JIC.....
	while ( !m_reqList.IsEmpty() )
	{
		CRequest* pRequest = (CRequest*)(m_reqList.RemoveTail());
		pRequest->Release();
	}
}

void CHttpSvrDoc::SetPathName(LPCTSTR lpszPathName, BOOL bAddToMRU) 
{
	// don't do any fancy-schmancy title-changing, etc.
	m_strPathName = lpszPathName;
}

BOOL CHttpSvrDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// set the title to be the URL of this server....
	CString strURL = "http://" 
		+ ((CHttpSvrApp*)AfxGetApp())->m_strServer;
	SetTitle( strURL );
	// zero the hits counter....
	m_nTotalHits = 0;

	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CHttpSvrDoc serialization

void CHttpSvrDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CHttpSvrDoc diagnostics

#ifdef _DEBUG
void CHttpSvrDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CHttpSvrDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CHttpSvrDoc commands

void CHttpSvrDoc::DocHit( CRequest* pRequest )
{
	// save the request object....
	pRequest->AddRef();
	m_reqList.AddTail( pRequest );
	// increment the total hit count....
	++m_nTotalHits; 
	// tell the view we got a new doc hit....
	UpdateAllViews( NULL, HINT_DOCHIT, pRequest );
}

BOOL CHttpSvrDoc::IdleProc( LONG lCount )
{
	BOOL bMore = FALSE;
	// if there's still requests in the list....
	if ( !m_reqList.IsEmpty() )
	{
		// pull off the first item....
		CRequest* pRequest = (CRequest*)(m_reqList.RemoveHead());
		// if it's done....
		if ( pRequest->m_bDone )
		{
			// process it for the stats....
			ExtractStats( pRequest );
			// done with it....
			pRequest->Release();
			// more idle needed if not empty....
			bMore = !m_reqList.IsEmpty();
		}
		else
		{
			// move to end of list....
			m_reqList.AddTail( pRequest );
			// still need to come back....
			bMore = TRUE;
		}
	}
	return bMore;
}

void CHttpSvrDoc::ExtractStats( CRequest* pRequest )
{
	// increment the status' group count....
	if ( pRequest->m_uStatus >= 100 && pRequest->m_uStatus < 600 )
		++m_aReStats[ pRequest->m_uStatus/100 - 1 ];
	else
		++m_aReStats[ STATUS_SERVERERR ]; // JIC

	// do whatever else you want with the CRequest object
	// for statistical purposes....
}

